/**********************************************************************
*
* autolaunch file.c -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* Written by Eric Soldan.
*
**********************************************************************/

#include <types.h>
#include <memory.h>
#include <stdfile.h>
#include <misctool.h>

#define __file__ 1
#include "autolaunch.h"

/**********************************************************************/

void			spreadTheWord(file, theRefNum)
FileIO			*file;
unsigned int	theRefNum;
{
	/* We want the file refNum in all the structures that may be used. */

	file->close.refNum     =
	file->readWrite.refNum =
	file->getPos.refNum    =
	file->setPos.refNum    =
		theRefNum;
}

/**********************************************************************/

unsigned int	openFile(file)
FileIO			*file;
{
	static GSString255	netpath = {
		17,
		"@:AutoLaunch.Data"
	};

	file->open.pathname = &netpath;
	file->create.pathname = &netpath;

	OpenGS(&file->open);					/* Open the file. */
	if (_fileErr = _toolErr ) return(_fileErr);

	spreadTheWord(file, file->open.refNum);

	return(0);								/* _fileErr = 0 also. */
}

/**********************************************************************/

unsigned int	readFile(file)
FileIO			*file;
{
	ReadGS(&file->readWrite);
	_fileErr = _toolErr;
	return(file->readWrite.transferCount);
}

/**********************************************************************/

unsigned int	writeFile(file)
FileIO			*file;
{
	WriteGS(&file->readWrite);
	_fileErr = _toolErr;
	return(file->readWrite.transferCount);
}

/**********************************************************************/

unsigned int	closeFile(file)
FileIO			*file;
{
	CloseGS(&file->close);
	if (_fileErr = _toolErr) return(_fileErr);
	spreadTheWord(file, 0);

	return(0);
}

/**********************************************************************/

unsigned int	fileErr()
{
	if (_fileErr) ErrorWindow(0, NULL, _fileErr);
	return(_fileErr);
}

/**********************************************************************/
/**********************************************************************/
/**********************************************************************/

void	getFileInfo()
{
	file.info.pathname = (GSString255Ptr)launch.triggerPath;
	GetFileInfo(&file.info);
	if (!(_fileErr = _toolErr))
		BlockMove(&file.info.modDateTime, &launch.dates[2], 8L);
	return;
}

/**********************************************************************/

void	getLaunchInfo()
{
	unsigned int	err;

	if (openFile(&file)) return;		/* We errored.  Shucks. */
	readFile(&file);
	err = _fileErr;
	closeFile(&file);
	if (err) _fileErr = err;

	if (_fileErr) {
		initLaunchData();
		return;
	}

	getFileInfo();
	if (_fileErr) {
		initLaunchData();
		return;
	}

	if (!launch.timer) launch.timer++;
	launch.dates[0] = launch.dates[2];
	launch.dates[1] = launch.dates[3];
}

/**********************************************************************/

void	saveLaunchInfo()
{
	unsigned int	err;

	openFile(&file);
	if (_fileErr) {
		if (_fileErr != fileNotFound) {
			fileErr();
			return;
		}

		CreateGS(&file.create);
		if (_fileErr = _toolErr) {
			fileErr();
			return;
		}

		openFile(&file);
		if (_fileErr) {
			if (_fileErr != fileNotFound) {
				fileErr();
				return;
			}
		}
	}

	writeFile(&file);
	err = _fileErr;
	closeFile(&file);
	if (err) _fileErr = err;
}

/**********************************************************************/

void			doNetCheck(initialize)
unsigned int	initialize;
{
	unsigned long			curTime;
	static unsigned long	oldTime;

	curTime = GetTick();

	if (initialize) {
		oldTime = curTime;
		return;
	}

	updateLaunchTimer();	/* See what the user says now. */

	if (oldTime + 60 * launch.timer < curTime) {
		oldTime = curTime;
		getFileInfo();
		if (!_fileErr) {
			if (
				(launch.dates[0] != launch.dates[2]) || 
				(launch.dates[1] != launch.dates[3])
			) {
				quitFlag = 2;
			}
		}
	}
	return;
}

/**********************************************************************/

unsigned int	truncFileName(path)
GSString255Ptr	path;
{
	unsigned int	c, i, oldLen;

	oldLen = path->length;
	for (i = oldLen; --i;) {
		c = path->text[i];
		if ((c == ':') || (c == '/')) {
			path->length = i;
			break;
		}
	}

	return(oldLen);
}

